% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{dt_percent_not_na}
\alias{dt_percent_not_na}
\title{Return the percentage of non-NA instances in a data.table column}
\usage{
dt_percent_not_na(DT, acolumn)
}
\arguments{
\item{DT}{A data.table object}

\item{acolumn}{a quoted column name}
}
\value{
Returns percentage of non-NA instances in column
}
\description{
This function takes a data.table and a quoted column name and
returns the percentage of the data in the column that is not
NA.
The percent is out of 100 and contains up to two decimal places
}
\examples{

mt <- as.data.table(mtcars)
mt[mpg<16, mpg:=NA]
dt_percent_not_na(mt, "mpg")         # 68.75

}
\seealso{
\code{\link{is.na}}
}
