% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{imath_rotate_point}
\alias{imath_rotate_point}
\title{Rotate Point}
\usage{
imath_rotate_point(point, angles)
}
\arguments{
\item{point}{A length-3 numeric vector (x, y, z)}

\item{angles}{A length-3 numeric vector (rotation angles in radians)}
}
\value{
The rotated point as an R numeric vector
}
\description{
This rotates a point around the origin at the angles specified. This
function is primarily just included as an example of integrating the Imath
library into a package. See imath-info.cpp in the source for the corresponding
C++ code.
}
\examples{
# This rotates a point around an angle.
point = c(1.0, 0.0, 0.0)
angles = c(0.0, pi/4, 0.0)
imath_rotate_point(point, angles)
}
