% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_sync}
\alias{lib_sync}
\title{Synchronize Loaded Library}
\usage{
lib_sync(x, name = NULL)
}
\arguments{
\item{x}{The data library to synchronize.}

\item{name}{The name of the library to sync if not the variable
name. Used internally.}
}
\value{
The synchronized data library.
}
\description{
The \code{lib_sync} function synchronizes the data
loaded into the working environment with the data stored 
in the library list.  Synchronization is necessary only
for libraries that have been loaded into the working environment.
The function
copies data from the working environment to the library
list, overwriting any data in the list. The function is useful when 
you want to update the library list, but are not yet ready to 
unload the data from working memory.  

Note that the \code{lib_sync} function does not 
write any data to disk. Also note that the \code{lib_sync} function will
not automatically remove any variables from the library list that 
have been removed from the workspace.  To remove items from the library
list, use the \code{\link{lib_remove}} function.  To write data to 
disk, use the \code{\link{lib_write}} function.
}
\examples{
# Create temp directory
tmp <- tempdir()

# Create library
libname(dat, tmp)
# library 'dat': 0 items
# - attributes: not loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
# NULL

# Load the library 
lib_load(dat)

# Add data to the workspace
dat.mtcars <- mtcars
dat.beaver1 <- beaver1
dat.iris <- iris

# Sync the library
lib_sync(dat)
# library 'dat': 3 items
# - attributes: loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
# - items:
#      Name Extension Rows Cols   Size LastModified
# 1 beaver1        NA  114    4 4.6 Kb         <NA>
# 2    iris        NA  150    5 7.1 Kb         <NA>
# 3  mtcars        NA   32   11   7 Kb         <NA>

# Clean up
lib_delete(dat)
}
\seealso{
Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_export}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
