/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/DiagnosticIndividualParams.h>
#include <so/private/DiagnosticIndividualParams.h>

so_DiagnosticIndividualParams *so_DiagnosticIndividualParams_new()
{
	so_DiagnosticIndividualParams *object = calloc(sizeof(so_DiagnosticIndividualParams), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_DiagnosticIndividualParams *so_DiagnosticIndividualParams_copy(so_DiagnosticIndividualParams *self)
{
	so_DiagnosticIndividualParams *dest = so_DiagnosticIndividualParams_new();
	if (dest) {
		if (self->RandomEffects) {
			dest->RandomEffects = so_Table_copy(self->RandomEffects);
			if (!dest->RandomEffects) {
				so_DiagnosticIndividualParams_free(dest);
				return NULL;
			}
		}
		if (self->IndivParamsCovariates) {
			dest->IndivParamsCovariates = so_Table_copy(self->IndivParamsCovariates);
			if (!dest->IndivParamsCovariates) {
				so_DiagnosticIndividualParams_free(dest);
				return NULL;
			}
		}
		if (self->DistributionIndivParams) {
			dest->DistributionIndivParams = so_Table_copy(self->DistributionIndivParams);
			if (!dest->DistributionIndivParams) {
				so_DiagnosticIndividualParams_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_DiagnosticIndividualParams_free(so_DiagnosticIndividualParams *self)
{
	if (self) {
		so_Table_unref(self->RandomEffects);
		so_Table_unref(self->IndivParamsCovariates);
		so_Table_unref(self->DistributionIndivParams);
		free(self);
	}
}

void so_DiagnosticIndividualParams_ref(so_DiagnosticIndividualParams *self)
{
	self->reference_count++;
}

void so_DiagnosticIndividualParams_unref(so_DiagnosticIndividualParams *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_DiagnosticIndividualParams_free(self);
		}
	}
}

so_Table *so_DiagnosticIndividualParams_get_RandomEffects(so_DiagnosticIndividualParams *self)
{
	return self->RandomEffects;
}

so_Table *so_DiagnosticIndividualParams_get_IndivParamsCovariates(so_DiagnosticIndividualParams *self)
{
	return self->IndivParamsCovariates;
}

so_Table *so_DiagnosticIndividualParams_get_DistributionIndivParams(so_DiagnosticIndividualParams *self)
{
	return self->DistributionIndivParams;
}

void so_DiagnosticIndividualParams_set_RandomEffects(so_DiagnosticIndividualParams *self, so_Table *value)
{
	so_Table_unref(self->RandomEffects);
	self->RandomEffects = value;
}

void so_DiagnosticIndividualParams_set_IndivParamsCovariates(so_DiagnosticIndividualParams *self, so_Table *value)
{
	so_Table_unref(self->IndivParamsCovariates);
	self->IndivParamsCovariates = value;
}

void so_DiagnosticIndividualParams_set_DistributionIndivParams(so_DiagnosticIndividualParams *self, so_Table *value)
{
	so_Table_unref(self->DistributionIndivParams);
	self->DistributionIndivParams = value;
}

so_Table *so_DiagnosticIndividualParams_create_RandomEffects(so_DiagnosticIndividualParams *self)
{
	so_Table *obj = so_Table_new("RandomEffects");
	if (obj) {
		self->RandomEffects = obj;
	}
	return obj;
}

so_Table *so_DiagnosticIndividualParams_create_IndivParamsCovariates(so_DiagnosticIndividualParams *self)
{
	so_Table *obj = so_Table_new("IndivParamsCovariates");
	if (obj) {
		self->IndivParamsCovariates = obj;
	}
	return obj;
}

so_Table *so_DiagnosticIndividualParams_create_DistributionIndivParams(so_DiagnosticIndividualParams *self)
{
	so_Table *obj = so_Table_new("DistributionIndivParams");
	if (obj) {
		self->DistributionIndivParams = obj;
	}
	return obj;
}

int so_DiagnosticIndividualParams_xml(so_DiagnosticIndividualParams *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->RandomEffects || self->IndivParamsCovariates || self->DistributionIndivParams) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "DiagnosticIndividualParams");
		if (rc < 0) return 1;
		if (self->RandomEffects) {
			rc = so_Table_xml(self->RandomEffects, writer, "RandomEffects");
			if (rc != 0) return rc;
		}
		if (self->IndivParamsCovariates) {
			rc = so_Table_xml(self->IndivParamsCovariates, writer, "IndivParamsCovariates");
			if (rc != 0) return rc;
		}
		if (self->DistributionIndivParams) {
			rc = so_Table_xml(self->DistributionIndivParams, writer, "DistributionIndivParams");
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_DiagnosticIndividualParams_start_element(so_DiagnosticIndividualParams *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_RandomEffects) {
		int fail = so_Table_start_element(self->RandomEffects, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_IndivParamsCovariates) {
		int fail = so_Table_start_element(self->IndivParamsCovariates, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_DistributionIndivParams) {
		int fail = so_Table_start_element(self->DistributionIndivParams, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "RandomEffects") == 0) {
		so_Table *RandomEffects = so_DiagnosticIndividualParams_create_RandomEffects(self);
		if (!RandomEffects) {
			return 1;
		}
		self->in_RandomEffects = 1;
	} else if (strcmp(localname, "IndivParamsCovariates") == 0) {
		so_Table *IndivParamsCovariates = so_DiagnosticIndividualParams_create_IndivParamsCovariates(self);
		if (!IndivParamsCovariates) {
			return 1;
		}
		self->in_IndivParamsCovariates = 1;
	} else if (strcmp(localname, "DistributionIndivParams") == 0) {
		so_Table *DistributionIndivParams = so_DiagnosticIndividualParams_create_DistributionIndivParams(self);
		if (!DistributionIndivParams) {
			return 1;
		}
		self->in_DistributionIndivParams = 1;
	}
	return 0;
}

void so_DiagnosticIndividualParams_end_element(so_DiagnosticIndividualParams *self, const char *localname)
{
	if (strcmp(localname, "RandomEffects") == 0 && self->in_RandomEffects) {
		self->in_RandomEffects = 0;
	} else if (strcmp(localname, "IndivParamsCovariates") == 0 && self->in_IndivParamsCovariates) {
		self->in_IndivParamsCovariates = 0;
	} else if (strcmp(localname, "DistributionIndivParams") == 0 && self->in_DistributionIndivParams) {
		self->in_DistributionIndivParams = 0;
	} else if (self->in_RandomEffects) {
		so_Table_end_element(self->RandomEffects, localname);
	} else if (self->in_IndivParamsCovariates) {
		so_Table_end_element(self->IndivParamsCovariates, localname);
	} else if (self->in_DistributionIndivParams) {
		so_Table_end_element(self->DistributionIndivParams, localname);
	}
}

int so_DiagnosticIndividualParams_characters(so_DiagnosticIndividualParams *self, const char *ch, int len)
{
	if (self->in_RandomEffects) {
		int fail = so_Table_characters(self->RandomEffects, ch, len);
		if (fail) return 1;
	} else if (self->in_IndivParamsCovariates) {
		int fail = so_Table_characters(self->IndivParamsCovariates, ch, len);
		if (fail) return 1;
	} else if (self->in_DistributionIndivParams) {
		int fail = so_Table_characters(self->DistributionIndivParams, ch, len);
		if (fail) return 1;
	}
	return 0;
}
