% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lastrees_watershed.r
\name{lastrees_watershed}
\alias{lastrees_watershed}
\title{Individual tree segmentation}
\usage{
lastrees_watershed(las, chm, th_tree = 2, tol = 1, ext = 1,
  extra = FALSE, ...)
}
\arguments{
\item{las}{An object of the class \code{LAS}. If missing \code{extra} is turned to \code{TRUE}
automatically.}

\item{chm}{RasterLayer. Image of the canopy. Can be computed with \link[lidR:grid_canopy]{grid_canopy}
or \link[lidR:grid_tincanopy]{grid_tincanopy} or read it from an external file.}

\item{th_tree}{numeric. Threshold below which a pixel cannot be a tree. Default 2.}

\item{tol}{numeric. Tolerance see ?EBImage::watershed.}

\item{ext}{numeric. see ?EBImage::watershed.}

\item{extra}{logical. By default the function classifies the original point cloud by reference
and return nothing (NULL) i.e. the original point cloud is automatically updated in place. If
\code{extra = TRUE} an additional \code{RasterLayer} used internally can be returned.}

\item{...}{Supplementary options. Currently \code{field} is supported to change the default name of
the new column.}
}
\value{
Nothing (NULL), the point cloud is updated by reference. The original point cloud
has a new column named \code{'treeID'} (or something else if the \code{field} option has been changed)
containing an ID for each point that refer to a segmented tree.
If \code{extra = TRUE} the function returns a \code{RasterLayer} used internally.
}
\description{
Individual tree segmentation using a simple watershed. This method is a
\href{https://en.wikipedia.org/wiki/Watershed_(image_processing)}{watershed segmentation}
method. It is based on the bioconductor package \code{EBIimage}. You need to install this package
to run this method (see its \href{https://github.com/aoles/EBImage}{github page}).
}
\seealso{
Other tree_segmentation: \code{\link{lastrees_dalponte}},
  \code{\link{lastrees_li2}}, \code{\link{lastrees_silva}},
  \code{\link{lastrees}}
}
