% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-LAS.r, R/methods-LAS.r
\docType{class}
\name{LAS-class}
\alias{LAS-class}
\alias{LAS}
\title{An S4 class to represent a .las or .laz file}
\usage{
LAS(data, header = list(), proj4string = sp::CRS(), check = TRUE)
}
\arguments{
\item{data}{a \link[data.table:data.table]{data.table} containing the data of a las or laz file.}

\item{header}{a \code{list} or a \link[lidR:LASheader-class]{LASheader} containing the header of
a las or laz file.}

\item{proj4string}{projection string of class \link[sp:CRS-class]{CRS-class}.}

\item{check}{logical. Conformity tests while building the object.}
}
\value{
An object of class \code{LAS}
}
\description{
Class LAS is the representation of a las/laz file according to the
\href{http://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format specifications}.
}
\details{
A \code{LAS} object inherits a \link[sp:Spatial-class]{Spatial} object from \code{sp}. Thus it is
a \code{Spatial} object plus a \code{data.table} with the data read from  a \code{las/laz} file and
a \link[lidR:LASheader-class]{LASheader} (see the ASPRS documentation for the
\href{http://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format}
for more information). Because las files are standardized the table of attributes read from the las/laz file
is also standardized. Columns are named:
\itemize{
\item{\code{X} (numeric)}
\item{\code{Y} (numeric)}
\item{\code{Z} (numeric)}
\item{\code{Intensity} (integer)}
\item{\code{ReturnNumber} (integer)}
\item{\code{NumberOfReturns} (integer)}
\item{\code{ScanDirectionFlag} (integer)}
\item{\code{EdgeOfFlightline} (integer)}
\item{\code{Classification} (integer)}
\item{\code{Synthetic_flag} (logical)}
\item{\code{Keypoint_flag} (logical)}
\item{\code{Withheld_flag} (logical)}
\item{\code{ScanAngle} (integer)}
\item{\code{UserData} (integer)}
\item{\code{PointSourceID} (integer)}
}
}
\section{Functions}{
\itemize{
\item \code{LAS}: Create objects of class LAS
}}

\section{Slots}{

\describe{
\item{\code{bbox}}{Object of class \code{matrix}, with bounding box}

\item{\code{proj4string}}{Object of class \link[sp:CRS-class]{CRS}, projection string}

\item{\code{data}}{Object of class \link[data.table:data.table]{data.table}. Point cloud data according to the
\href{http://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format}}

\item{\code{header}}{Object of class \link[lidR:LASheader-class]{LASheader}. las file header according to the
\href{http://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format}}
}}

\section{Extends}{

Class  \link[sp:Spatial-class]{Spatial}, directly.
}

\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile)

}
\seealso{
\link{readLAS}
}
