% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_readLAS.r
\name{readLASheader}
\alias{readLASheader}
\title{Read a .las or .laz file header}
\usage{
readLASheader(file)
}
\arguments{
\item{file}{characters. Path to one file.}
}
\value{
A LASheader object
}
\description{
Reads a .las or .laz file header into an object of class \link[lidR:LASheader-class]{LASheader}.
This function strictly reads the header while the function \link{readLAS} can alter the header to
fit the actual data loaded.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
header = readLASheader(LASfile)

print(header)
plot(header)

\dontrun{
plot(header, mapview = TRUE)}
}
