% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_shapes.R
\name{segment_shapes}
\alias{segment_shapes}
\title{Estimation of the shape of the points neighborhood}
\usage{
segment_shapes(las, algorithm, attribute = "Shape", filter = NULL)
}
\arguments{
\item{las}{an object of class LAS}

\item{algorithm}{An algorithm for shape detection. lidR has: \link{shp_plane}, \link{shp_hplane}
and \link{shp_line}.}

\item{attribute}{character. The name of the new column to add into the LAS object.}

\item{filter}{formula of logical predicates. Enables the function to run only on points of interest
in an optimized way. See also examples.}
}
\value{
A LAS object with a new column named after the argument \code{attribute} that indicates
those points that are part of a neighborhood that is approximately of the shape searched (TRUE)
or not (FALSE).
}
\description{
Computes the eigenvalues of the covariance matrix of the neighbouring points using several possible
algorithms. The points that meet a given criterion based on the eigenvalue are labeled as approximately
coplanar/colinear or any other shape supported.
}
\examples{
\dontrun{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las <- readLAS(LASfile)

las <- segment_shapes(las, shp_plane(k = 15), "Coplanar")
plot(las, color = "Coplanar")

# Drop ground point at runtime
las <- segment_shapes(las, shp_plane(k = 15), "Coplanar", filter = ~Classification != 2L)
plot(las, color = "Coplanar")
}

}
