% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-gnd.R
\name{pmf}
\alias{pmf}
\title{Ground Segmentation Algorithm}
\usage{
pmf(ws, th)
}
\arguments{
\item{ws}{numeric. Sequence of windows sizes to be used in filtering ground returns.
The values must be positive and in the same units as the point cloud (usually meters, occasionally
feet).}

\item{th}{numeric. Sequence of threshold heights above the parameterized ground surface to be
considered a ground return. The values must be positive and in the same units as the point cloud.}
}
\description{
This function is made to be used in \link{classify_ground}. It implements an algorithm for segmentation
of ground points based on a progressive morphological filter. This method is an implementation of
the Zhang et al. (2003) algorithm (see reference). Note that this is not a strict implementation
of Zhang et al. This algorithm works at the point cloud level without any rasterization process.
The morphological operator is applied on the point cloud, not on a raster. Also, Zhang et al.
proposed some formulas (eq. 4, 5 and 7) to compute the sequence of windows sizes and thresholds.
Here, these parameters are free and specified by the user. The function \link{util_makeZhangParam}
enables computation of the parameters according to the original paper.
}
\examples{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las <- readLAS(LASfile, select = "xyzrn", filter = "-inside 273450 5274350 273550 5274450")

ws <- seq(3,12, 3)
th <- seq(0.1, 1.5, length.out = length(ws))

las <- classify_ground(las, pmf(ws, th))
#plot(las, color = "Classification")
}
\references{
Zhang, K., Chen, S. C., Whitman, D., Shyu, M. L., Yan, J., & Zhang, C. (2003). A progressive
morphological filter for removing nonground measurements from airborne LIDAR data. IEEE
Transactions on Geoscience and Remote Sensing, 41(4 PART I), 872–882. http:#doi.org/10.1109/TGRS.2003.810682.
}
\seealso{
Other ground segmentation algorithms: 
\code{\link{csf}()}
}
\concept{ground segmentation algorithms}
