% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-itd.R
\name{itd_manual}
\alias{itd_manual}
\alias{manual}
\title{Individual Tree Detection Algorithm}
\usage{
manual(detected = NULL, radius = 0.5, color = "red", button = "middle", ...)
}
\arguments{
\item{detected}{\code{SpatialPoints* or }sf/sfc_POINT` with  2 or 3D points of already found tree tops
that need manual correction. Can be NULL}

\item{radius}{numeric. Radius of the spheres displayed on the point cloud (aesthetic purposes only).}

\item{color}{character. Colour of the spheres displayed on the point cloud (aesthetic purposes only).}

\item{button}{Which button to use for selection. One of "left", "middle", "right". lidR using left
for rotation and right for dragging using one of left or right will disable either rotation or dragging}

\item{...}{supplementary parameters to be passed to \link{plot}.}
}
\description{
This function is made to be used in \link{locate_trees}. It implements an algorithm for manual
tree detection. Users can pinpoint the tree top positions manually and interactively using the mouse.
This is only suitable for small-sized plots. First the point cloud is displayed, then the user is
invited to select a rectangular region of interest in the scene using the mouse button.
Within the selected region the highest point will be flagged as 'tree top' in the scene. Once all the trees
are labelled the user can exit the tool by selecting an empty region. Points can also be unflagged.
The goal of this tool is mainly for minor correction of automatically-detected tree outputs.
}
\examples{
\dontrun{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las = readLAS(LASfile)

# Full manual tree detection
ttops = locate_trees(las, manual())

# Automatic detection with manual correction
ttops = locate_trees(las, lmf(5))
ttops = locate_trees(las, manual(ttops))
}
}
\seealso{
Other individual tree detection algorithms: 
\code{\link{itd_lmf}}
}
\concept{individual tree detection algorithms}
