% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fullwaveform.R
\name{interpret_waveform}
\alias{interpret_waveform}
\title{Convert full waveform data into a regular point cloud}
\usage{
interpret_waveform(las)
}
\arguments{
\item{las}{An object of class LAS with full waveform data}
}
\value{
An object of class LAS 1.2 format 0 with one point per records
}
\description{
Full waveform can be difficult to manipulate and visualize in R. This function converts
a LAS object with full waveform data into a regular point cloud. Each waveform record
becomes a point with XYZ coordinates and an amplitude (units: volts) and an ID that records
each original pulse. Notice that this has the effect of drastically inflating the size of the
object in memory, which is likely already very large
}
\section{Full waveform}{

With most recent versions of the \code{rlas} package, full waveform (FWF) can be read and \code{lidR}
provides some compatible functions. However, the support of FWF is still a work-in-progress
in the \code{rlas} package. How it is read, interpreted and represented in R may change. Consequently,
tools provided by \code{lidR} may also change until the support of FWF becomes mature and
stable in \code{rlas}. See also \link[rlas:read.las]{rlas::read.las}.\cr\cr
Remember that FWF represents an insanely huge amount of data. It terms of memory it is like
having between 10 to 100 times more points. Consequently, loading FWF data in R should be
restricted to relatively small point clouds.
}

\examples{
\dontrun{
LASfile <- system.file("extdata", "fwf.laz", package="rlas")
fwf <- readLAS(LASfile)
las <- interpret_waveform(fwf)
x <- plot(fwf, size = 3, pal = "red")
plot(las, color = "Amplitude", bg = "white", add = x, size = 2)
}
}
