% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_demographicFunctions.R
\name{exn}
\alias{exn}
\title{Expected residual life.}
\usage{
exn(object, x, n, type = "curtate")
}
\arguments{
\item{object}{A lifetable/actuarialtable object.}

\item{x}{Attained age}

\item{n}{Time until which the expected life should be calculated. Assumed omega - x whether missing.}

\item{type}{Either \code{"Tx"}, \code{"complete"} or \code{"continuous"} for continuous future lifetime, 
\code{"Kx"} or \code{"curtate"} for curtate furture lifetime (can be abbreviated).}
}
\value{
A numeric value representing the expected life span.
}
\description{
Expected residual life.
}
\examples{
#loads and show
data(soa08Act)
exn(object=soa08Act, x=0)
exn(object=soa08Act, x=0,type="complete")
}
\references{
Actuarial Mathematics (Second Edition), 1997, by Bowers, N.L., Gerber, H.U., Hickman, J.C., 
Jones, D.A. and Nesbitt, C.J.
}
\seealso{
\code{\linkS4class{lifetable}}
}
\author{
Giorgio Alfredo Spedicato
}
