% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiments.R
\name{create_dataset}
\alias{create_dataset}
\title{Creates a dataset across data sources in a Person object}
\usage{
create_dataset(person, all_variables, time_var)
}
\arguments{
\item{person}{an instantiated Person object}

\item{all_variables}{list of variables in person to join, with structure 
list(source1 = c(var1, var2), source2 = c(var3, var4))
where source is a source of data as defined in a Person
object, and var1 and var2 are variables from source1, 
while var3 and var4 are variables from source2}

\item{time_var}{the time variable to join the datasets across (time, date, 
                                               or datetime)
as a character}
}
\value{
one dataframe with all variables in all_variables, joined by time_var
}
\description{
Joins all variables (across sources) by time_var into one 
             dataframe, which is returned
}
\examples{
data(EX)
dataset <- create_dataset(person = EX,
                          all_variables = list("util" = c("month"),
                                               "fitbit_daily" = c("steps")),
                          time_var = c("date"))

}
