% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{gsea}
\alias{gsea}
\title{Gene set enrichment analysis}
\usage{
gsea(values, geneset, power = 1, rank = FALSE, weight = rep(1,
  length(values)), n.rand = 10000, plot = TRUE, return.details = FALSE,
  quantile.threshold = min(100/n.rand, 0.1), random.seed = 1,
  mc.cores = 1)
}
\arguments{
\item{values}{vector of values with associated gene names; values must be named, according to names appearing in set elements}

\item{geneset}{vector of genes in the gene set}

\item{power}{an exponent to control the weight of the step (default: 1)}

\item{rank}{whether to use ranks as opposed to values (default: FALSE)}

\item{weight}{additional weights associated with each value (default: rep(1,length(values)))}

\item{n.rand}{number of random permutations used to assess significance (default: 1e4)}

\item{plot}{whether to plot (default: TRUE)}

\item{return.details}{whether to return extended details (default: FALSE)}

\item{quantile.threshold}{threshold used (default: min(100/n.rand,0.1))}

\item{random.seed}{random seed (default: 1)}

\item{mc.cores}{number of cores for parallel processing (default: 1)}
}
\description{
Gene set enrichment analysis
}
\examples{
data("org.Hs.GO2Symbol.list")  
universe <- unique(unlist(org.Hs.GO2Symbol.list))  # get universe
gs <- org.Hs.GO2Symbol.list[[1]]  # get a gene set
# fake dummy example where everything in gene set is perfectly enriched
vals <- rnorm(length(universe), 0, 10)  
names(vals) <- universe
vals[gs] <- rnorm(length(gs), 100, 10)
# test obviously enriched set, reduce n.rand for speed
gsea(values=vals, geneset=gs, mc.cores=1, n.rand=100) 

}
