% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lilikoi.explr.R
\name{lilikoi.explr}
\alias{lilikoi.explr}
\title{Exploratory analysis}
\usage{
lilikoi.explr(data, demo.data, pca = FALSE, tsne = FALSE)
}
\arguments{
\item{data}{is a input data frame for analysis with sample ids as row names and metabolite names or pathway names as column names.}

\item{demo.data}{is a demographic data frame with sample ids as row names, sample groups and demographic variable names as column names.}

\item{pca}{if TRUE, PCA plot will be out.}

\item{tsne}{if TRUE, T-SNE plot will be out.}
}
\value{
Source of variation test results and PCA and t-SNE plot
}
\description{
Performs source of variation test and build PCA and t-SNE plots to visualize important information.
}
\examples{
\donttest{
lilikoi.explr(data, demo.data, pca=TRUE, tsne=FALSE)
}
}
