% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lilikoi.preproc_norm.R
\name{lilikoi.preproc_norm}
\alias{lilikoi.preproc_norm}
\title{A Normalization function.}
\usage{
lilikoi.preproc_norm(
  inputdata = Metadata,
  method = c("standard", "quantile", "median")
)
}
\arguments{
\item{inputdata}{An expression data frame with samples in the rows, metabolites in the columns}

\item{method}{The method to be used to process data, including standard normalization (standard), quantile
normalization (quantile) and median fold normalization (median).}
}
\value{
A normalized dataset with samples in the rows, metabolites in the columns.
}
\description{
This function is used to preprocess data via normalization.
It provides three normalization methods: standard normalization, quantile
normalization and median fold normalization. The median fold normalization is adapted
from http://www.metabolomics-forum.com/index.php?topic=281.0.
}
\examples{
\donttest{
dt <- lilikoi.Loaddata(file=system.file("extdata",
 "plasma_breast_cancer.csv", package = "lilikoi"))
Metadata <- dt$Metadata
dataSet <- dt$dataSet
lilikoi.preproc_norm(inputdata=Metadata, method="standard")
}
}
