% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clamps.R
\name{clamp}
\alias{clamp}
\alias{clamp_robust}
\alias{clamp_sd}
\alias{clamp_standardize}
\title{Rescale all columns of a matrix}
\usage{
clamp(.data)

clamp_robust(.data)

clamp_sd(.data, sd = 1)

clamp_standardize(.data, sd = 1)
}
\arguments{
\item{.data}{A numeric matrix}

\item{sd}{the value of each columns standard deviation (default is 1)}
}
\value{
A matrix with the same dimension as \code{.data} where each column has
been rescaled.
}
\description{
Rescale all columns of a matrix
}
\details{
These functions are used internally by the tour to rescale all
columns of \code{.data}.
\itemize{
\item \code{clamp()} rescales so all values for each column lie in the unit interval
\item \code{clamp_robust()} rescales by first centering by the median and then scaling
by the median absolute deviation.
\item \code{clamp_sd()} rescales all columns to have a fixed standard deviation.
\item \code{clamp_standardize()} rescales all columns to have zero mean and unit variance.
}
}
\examples{
mv <- matrix(rnorm(30), ncol = 3)

clamp(mv)

clamp_robust(mv)

clamp_sd(mv)

clamp_standardize(mv)
}
