% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{k2gaussian}
\alias{k2gaussian}
\title{2D Gaussian Kernel Matrix for \code{"lineqGP"} Models.}
\usage{
k2gaussian(x1, x2, par, d = 2)
}
\arguments{
\item{x1}{a matrix with the first couple of input locations.}

\item{x2}{a matrix with the second couple of input locations.}

\item{par}{the values of the kernel parameters (variance, lengthscales).}

\item{d}{a number corresponding to the dimension of the input space.}
}
\value{
Kernel matrix \eqn{K(x_1,x_2)}{K(x1,x2)}
(or \eqn{K(x_1,x_1)}{K(x1,x1)} if \eqn{x_2}{x2} is not defined).
}
\description{
Compute the 2D Gaussian kernel matrix for \code{"lineqGP"} models.
attr: "gradient".
}
\examples{
xgrid <- seq(0, 1, 0.1)
x <- as.matrix(expand.grid(xgrid, xgrid))
K <- k2gaussian(x, x, par =  c(1, 0.1))
image(K, main = "covariance matrix using a 2D Gaussian kernel")

}
\author{
A. F. Lopez-Lopera.
}
