% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grassControl.R
\name{paramGRASSx}
\alias{paramGRASSx}
\title{Usually for internally usage, get 'GRASS GIS' and \code{rgrass} parameters on 'Linux' OS}
\usage{
paramGRASSx(
  set_default_GRASS = NULL,
  MP = "/usr/bin",
  ver_select = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{set_default_GRASS, }{default is NULL. will force a search for 'GRASS GIS' You may provide a valid combination as 
c('/usr/lib/grass74','7.4.1','grass74')}

\item{MP, }{default is '/usr/bin'. mount point to be searched.}

\item{ver_select}{if TRUE you must interactively select between alternative installations}

\item{quiet}{boolean, default is TRUE.  switch for suppressing console messages}
}
\description{
Initialize and set up \code{rgrass}  for 'Linux'
}
\details{
During the rsession you will have full access to GRASS7 GIS via the \code{rgrass} wrapper. Additionally you may use also use the API calls of GRASS via the command line.
}
\examples{

run = FALSE
if (run) {
# automatic retrieval of the GRASS environment settings
paramGRASSx()


# typical stand_alone installation
paramGRASSx('/usr/bin/grass72')

# typical user defined installation (compiled sources)
paramGRASSx('/usr/local/bin/grass72')
}
}
\keyword{internal}
