% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lint.R
\name{lint_package}
\alias{lint_package}
\title{Lint a package}
\usage{
lint_package(path = ".", relative_path = TRUE, ...,
  exclusions = list("R/RppExports.R"))
}
\arguments{
\item{path}{the path to the base directory of the package, if \code{NULL},
it will be searched in the parent directories of the current directory.}

\item{relative_path}{if \code{TRUE}, file paths are printed using their path
relative to the base directory.  If \code{FALSE}, use the full
absolute path.}

\item{...}{additional arguments passed to \code{\link{lint}}, e.g.
\code{cache} or \code{linters}.}

\item{exclusions}{exclusions for \code{\link{exclude}}, relative to the
package path.}
}
\value{
A list of lint objects.
}
\description{
Apply one or more linters to all of the R files in a package.
}
\examples{
\dontrun{
  lint_package()

  lint_package(
    linters = with_defaults(semicolon_linter = semicolon_terminator_linter())
    cache = TRUE,
    exclusions = list("inst/doc/creating_linters.R" = 1, "inst/example/bad.R")
  )
}
}
