% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lint.R
\name{lint}
\alias{lint}
\alias{lint_file}
\alias{lint_dir}
\alias{lint_package}
\title{Lint a file, directory, or package}
\usage{
lint(
  filename,
  linters = NULL,
  ...,
  cache = FALSE,
  parse_settings = TRUE,
  text = NULL
)

lint_dir(
  path = ".",
  ...,
  relative_path = TRUE,
  exclusions = list("renv", "packrat"),
  pattern = rex::rex(".", one_of("Rr"), or("", "html", "md", "nw", "rst", "tex",
    "txt"), end),
  parse_settings = TRUE
)

lint_package(
  path = ".",
  ...,
  relative_path = TRUE,
  exclusions = list("R/RcppExports.R"),
  parse_settings = TRUE
)
}
\arguments{
\item{filename}{either the filename for a file to lint, or a character string of inline R code for linting.
The latter (inline data) applies whenever \code{filename} has a newline character (\\n).}

\item{linters}{a named list of linter functions to apply. See \link{linters} for a full list of default and available
linters.}

\item{...}{additional arguments passed to \code{\link[=lint]{lint()}}, e.g. \code{linters} or \code{cache}.}

\item{cache}{given a logical, toggle caching of lint results. If passed a character string, store the cache in this
directory.}

\item{parse_settings}{whether to try and parse the settings.}

\item{text}{Optional argument for supplying a string or lines directly, e.g. if the file is already in memory or
linting is being done ad hoc.}

\item{path}{For the base directory of the project (for \code{lint_dir()}) or
package (for \code{lint_package()}).}

\item{relative_path}{if \code{TRUE}, file paths are printed using their path relative to the base directory.
If \code{FALSE}, use the full absolute path.}

\item{exclusions}{exclusions for \code{\link[=exclude]{exclude()}}, relative to the package path.}

\item{pattern}{pattern for files, by default it will take files with any of the extensions .R, .Rmd, .Rnw, .Rhtml,
.Rrst, .Rtex, .Rtxt allowing for lowercase r (.r, ...)}
}
\value{
A list of lint objects.
}
\description{
\itemize{
\item \code{lint()} lints a single file.
\item \code{lint_dir()} lints all files in a directory.
\item \code{line_pakage()} lints all likely locations for R files in a package, i.e.
\verb{R/}, \verb{tests/}, \verb{inst/}, \verb{vignettes/}, \verb{data-raw/}, and \verb{demo/}.
}
}
\details{
Read \code{vigentte("lintr")} to learn how to configure which linters are run
by default.
}
\examples{
\dontrun{
  lint("some/file-name.R") # linting a file
  lint("a = 123\n")        # linting inline-code
  lint(text = "a = 123")   # linting inline-code
}

\dontrun{
  lint_dir()
  lint_dir(
    linters = list(semicolon_linter())
    cache = TRUE,
    exclusions = list("inst/doc/creating_linters.R" = 1, "inst/example/bad.R", "renv")
  )
}
\dontrun{
  lint_package()

  lint_package(
    linters = linters_with_defaults(semicolon_linter = semicolon_linter())
    cache = TRUE,
    exclusions = list("inst/doc/creating_linters.R" = 1, "inst/example/bad.R")
  )
}
}
