% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liquidSVM.R
\name{svm}
\alias{svm}
\title{Convenience function to initialize, train, select, and optionally test an SVM.}
\usage{
svm(x, y, ..., do.select = TRUE, testdata = NULL,
  testdata_labels = NULL, scenario = NULL, d = NULL, scale = TRUE,
  predict.prob = FALSE)
}
\arguments{
\item{x}{either a formula or the features}

\item{y}{either the data or the labels corresponding to the features \code{x}.
It can be a \code{character} in which case the data is loaded using \code{\link{liquidData}}.
If it is of type \code{liquidData} then after \code{train}ing and \code{select}ion
the model is \code{\link{test}}ed using the testing data (\code{y$test}).}

\item{...}{configuration parameters, see \link{Configuration}. Can be \code{threads=2, display=1, gpus=1,} etc.}

\item{do.select}{can be set to a list to args to be passed to the select phase}

\item{testdata}{if supplied then also testing is performed.
If this is \code{NULL} but \code{y} is of type \code{liquidData} then
\code{y$test} is used.}

\item{testdata_labels}{the labels used if testing is also perfomed.}

\item{scenario}{configures the model for a learning scenario:
E.g. \code{scenario='ls', scenario='mc', scenario='npl', scenario='qt'} etc.
Unlike the specialized functions \code{qtSVM, exSVM, nplSVM} etc.
this does not trigger the correct \code{select}}

\item{d}{level of display information}

\item{scale}{if \code{TRUE} scales the features in the internal representation
to values between 0 and 1.}

\item{predict.prob}{If \code{TRUE} then a LS-svm will be trained and
the conditional probabilities for the binary classification problems will be estimated.
This also restricts the choices of \code{mc_type} to \code{c("OvA_ls","AvA_ls")}.}
}
\value{
an object of type \code{svm}. Depending on the usage this object
has also \code{$train_errors}, \code{$select_errors}, and \code{$last_result}
properties.
}
\description{
The model is inited using the features and labels provided and training and selection is performed.
If the labels are given as a \code{factor} classification is performed else least squares regression.
If testing data is provided then this is used to calculate predictions and if test labels are provided
also the test error and both are saved in \code{$last_result} of the returned \code{svm} object.
}
\details{
The training data can either be provided using a formula and a corresponding \code{data.frame}
or the features and the labels are given directly.

\code{svm} has one more difference to \code{\link{lsSVM}} and \code{\link{mcSVM}}
because it uses \code{scale=TRUE} by default and the others do not.
}
\examples{
# since Species is a factor the following performs multiclass classification
modelIris <- svm(Species ~ ., iris)
# equivalently
modelIris <- svm(iris[,1:4], iris$Species)

# since Height is numeric the following performs least-squares regression
modelTrees <- svm(Height ~ Girth + Volume, trees)
# equivalently
modelTrees <- svm(trees[,c(1,3)],trees$Height)
}
\seealso{
\code{\link{lsSVM}}, \code{\link{mcSVM}}, \code{\link{init.liquidSVM}}, \code{\link{trainSVMs}}, \code{\link{selectSVMs}}
}
