% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modify_along_dim}
\alias{modify_along_dim}
\alias{modify_along_rows}
\alias{modify_along_cols}
\title{Modify an array by mapping over 1 or more dimensions}
\usage{
modify_along_dim(X, which_dim, .f, ...)

modify_along_rows(X, .f, ...)

modify_along_cols(X, .f, ...)
}
\arguments{
\item{X}{An array, or a list of arrays}

\item{which_dim}{integer vector of dimensions to modify at}

\item{.f}{a function or formula defining a function(same semantics as
\code{\link[purrr:map]{purrr::map()}}). The function must return either an array the same shape
as it was passed, a vector of the same length, or a scalar, although the
type of the returned object does not need to be the same as was passed in.}

\item{...}{passed on to \code{.f()}}
}
\value{
An array, or if \code{X} was a list, a list of arrays of the same shape as
was passed in.
}
\description{
This function can be thought of as a version of \code{base::apply()} that is
guaranteed to return a object of the same dimensions as it was input. It also
generally preserves attributes, as it's built on top of \code{[<-}.
}
\examples{
x <- array(1:6, 1:3)
modify_along_dim(x, 3, ~mean(.x))
modify_along_dim(x, 3, ~.x/mean(.x))
}
