% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim.R
\name{expand_dims}
\alias{expand_dims}
\title{Expand the shape of an array}
\usage{
expand_dims(x, which_dim = -1L)
}
\arguments{
\item{x}{an array. Bare vectors are treated as 1-d arrays.}

\item{which_dim}{numeric. Desired index position of the new axis or axes in
the returned array. Negative numbers count from the back. Can be any
length.Throws a warning if any duplicates are provided.}
}
\value{
the array \code{x} with new dim
}
\description{
This is the inverse operation of \code{base::drop()}.
It is analogous to python's \code{numpy.expand_dims()}, but vectorized on
\code{which_dim}.
}
\examples{
x <- array(1:24, 2:4)
dim(x)
dim(expand_dims(x))
dim(expand_dims(x, 2))
dim(expand_dims(x, c(1,2)))
dim(expand_dims(x, c(1,-1)))
dim(expand_dims(x, 6)) # implicitly also expands dims 4,5
dim(expand_dims(x, 4:6))

# error, implicit expansion with negative indexes not supported
try(expand_dims(x, -6))

# supply them explicitly instead
dim(expand_dims(x, -(4:6)))
}
