% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_name_to_df.R
\name{list_name_to_df}
\alias{list_name_to_df}
\title{Add the names of list items to data frames.}
\usage{
list_name_to_df(in_list, column_name = ".group", skip_non_df = TRUE)
}
\arguments{
\item{in_list}{The list to work on. Must have names.}

\item{column_name}{The name of the column to add to the data frames.}

\item{skip_non_df}{Whether to skip items that are not data frames.}
}
\value{
The input list with the name of the list item added in a new column
for all data frames.
}
\description{
Add the names of list items to data frames.
}
\details{
With `column_name` you can specify the name the new columns in the
data.frames should have. The default is `.group`.

Using `skip_non_df` you can specify to omit elements from the input list
that are not data frames. If FALSE an error will be thrown if elements are
present that are not data frames. If TRUE (the default) then items that are
not data frames will be ignored and remain unchanged.
}
\examples{
my_list <- list(group1 = data.frame(x = 1:10, y = rnorm(10)),
                group2 = data.frame(x = 1:10, y = rnorm(10)))
list_name_to_df(my_list)
}
