% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{db_try_consume}
\alias{db_try_consume}
\title{Try to consume a message from the queue}
\usage{
db_try_consume(db, queue, crashed = TRUE, con = NULL)
}
\arguments{
\item{db}{DB file name.}

\item{queue}{Name of the queue.}
}
\description{
If there is a message that it \code{READY}, it returns that. Otherwise it
checks for crashed workers.
}
\section{Details of the implementation}{


The database must be locked for the whole operation, including
checking on or creating the lock databases.
\enumerate{
\item If there is a \code{READY} message, that one is taken.
\item Otherwise if there are \code{WORKING} messages, then
we check them one by one. This might take a lot of
time, and the DB must be locked for the whole search,
so it is not ideal. But I don't have a better solution
right now.
}

Taking a message means
\enumerate{
\item Updating its row.status to \code{WORKING}.
\item Creating another database that serves as the lock for this message.
}
}

\keyword{internal}
