% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_literanger}
\alias{read_literanger}
\title{De-serialize random forest}
\usage{
read_literanger(file, verbose = TRUE, ...)
}
\arguments{
\item{file}{A connection or the name of a file containing a serialized
\code{literanger} object.}

\item{verbose}{Show additional serialization information (not implemented).}

\item{...}{Further arguments passed to \code{\link[=readRDS]{readRDS()}}.}
}
\value{
A \code{literanger} random forest object
}
\description{
Read the random forest from a file or connection using light-weight
serialization for C++ objects.
}
\details{
This function uses \href{https://uscilab.github.io/cereal/}{'cereal'} light-weight serialization to
read a literanger object (random forest) from a file or connection. The
file is usually the result of a call to \code{\link[=write_literanger]{write_literanger()}}. The random
forest returned can be used for prediction immediately upon return, and does
not require the original training data or training environment.
}
\seealso{
\code{\link[=write_literanger]{write_literanger()}} \link{readRDS}
}
\author{
stephematician <stephematician@gmail.com
}
