% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{mann_kendall}
\alias{mann_kendall}
\alias{test_statistic.mann_kendall}
\alias{p_value.mann_kendall}
\title{Mann Kendall}
\usage{
mann_kendall(x, type = c("both", "increasing", "decreasing"))

\method{test_statistic}{mann_kendall}(x, ...)

\method{p_value}{mann_kendall}(x, ...)
}
\arguments{
\item{x}{numeric vector representing a time-series.}

\item{type}{direction to test (both, increasing, or decreasing).}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
object of class \code{Mann-Kendall}.
}
\description{
Performs Mann-Kendall non-parametric trend test.
}
\section{Methods (by generic)}{
\itemize{
\item \code{test_statistic}: Extracts Mann Kendall tau

\item \code{p_value}: Extract p-value
}}

\examples{

# create mann_kendall object
mk <- mann_kendall(c(9, 4, 7, 5, 3), type = "decreasing")

# get test statistic tau
test_statistic(mk)

# get p-value
p_value(mk)
}
\seealso{
\code{\link{test_statistic}}, \code{\link{p_value}}, \code{\link{cor.test}}
}
