/*
 * Decompiled with CFR 0.152.
 */
package shapleyComputation;

import java.util.Arrays;
import shapleyComputation.Combinations;

public class ShapleyComputation {
    public static void main(String[] stringArray) {
        ShapleyComputation.runExample();
    }

    private static void runExample() {
        int n = 3;
        double[] dArray = new double[(int)Math.pow(2.0, n)];
        dArray[0] = 0.0;
        dArray[1] = 3.0;
        dArray[2] = 3.0;
        dArray[3] = 6.0;
        dArray[4] = 1.5;
        dArray[5] = 4.0;
        dArray[6] = 4.0;
        dArray[7] = 6.0;
        double[] dArray2 = ShapleyComputation.computeShapleyValues(dArray);
        System.out.println(Arrays.toString(dArray2));
    }

    public static double computeShapleyValueOfOneAgent(int n, double[] dArray) {
        int n2;
        int n3 = (int)(Math.log10(dArray.length) / Math.log10(2.0));
        int n4 = (int)Math.pow(2.0, n - 1);
        int n5 = dArray.length;
        double d = 0.0;
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 <= n3 - 1; ++n2) {
            dArray2[n2] = 1.0 / (double)(Combinations.binomialCoefficient(n3, n2) * (long)(n3 - n2));
        }
        for (n2 = 0; n2 < n5; ++n2) {
            if ((n4 & n2) != 0) continue;
            int n6 = n2;
            int n7 = n2 + n4;
            int n8 = Integer.bitCount(n2);
            double d2 = dArray[n7] - dArray[n6];
            d += dArray2[n8] * d2;
        }
        return d;
    }

    public static double[] computeShapleyValues(double[] dArray) {
        int n = (int)(Math.log10(dArray.length) / Math.log10(2.0));
        double[] dArray2 = new double[n];
        for (int i = 1; i <= n; ++i) {
            dArray2[i - 1] = ShapleyComputation.computeShapleyValueOfOneAgent(i, dArray);
        }
        return dArray2;
    }
}

