% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lmdu.R
\name{plot.lmdu}
\alias{plot.lmdu}
\title{plots the results of a
logistic multidimensional unfolding (X = NULL)
logistic restricted multidimensional unfolding (X != NULL)}
\usage{
\method{plot}{lmdu}(
  x,
  dims = c(1, 2),
  ycol = "darkgreen",
  xcol = "lightskyblue",
  ocol = "grey",
  ...
)
}
\arguments{
\item{x}{an object of type lmdu}

\item{dims}{which dimensions to visualize}

\item{ycol}{colour for representation of response variables}

\item{xcol}{colour for representation of predictor variables}

\item{ocol}{colour for representation of row objects}

\item{\dots}{additional arguments to be passed.}
}
\value{
Plot of the results obtained from lmdu
}
\description{
plots the results of a
logistic multidimensional unfolding (X = NULL)
logistic restricted multidimensional unfolding (X != NULL)
}
\examples{
data(dataExample_lmdu)
Y = as.matrix(dataExample_lmdu[1:20 , 1:8])
X = as.matrix(dataExample_lmdu[1:20 , 9:13])
# unsupervised
output = lmdu(Y = Y, S = 2)
plot(output)

}
