% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwas.analysis.R
\name{gwas.analysis}
\alias{gwas.analysis}
\title{Performs GWAS analysis with five optional models and
different optional thresholds.}
\usage{
gwas.analysis (crossobj, method, provide.K,
covariates, trait, threshold, p,out.file)
}
\arguments{
\item{crossobj}{An object of class = cross obtained from
the gwas.cross function from this package,
or the read.cross function from r/qtl package (Broman and Sen, 2009).
This file contains phenotypic means, genotypic marker score, and genetic map.}

\item{method}{Methods to perform GWAS analysis.
Options are naive, fixed, kinship, QK and egeinstrat.
The general Mixed Model equation used is:
\deqn{Y = X \beta + Q \nu + Zu + e}, where Y is the phenotypic vector, X is the
molecular marker matrix,
\deqn{\beta} is the unknown vector of allelic effects to
be estimated,
Q is the population structure,
\deqn{\nu} is the vector of population effects (parameters),
Z is a matrix that relates each measurement to the individual from which it was
obtained,
u is the vector of random background polygenic effects, and
e is the residual errors. Random effects are underlined.

The following mainstream models are available with the package:
1) naive; a simple test of association (Kruskal-Wallis) with no correction for
population structure
\deqn{Y = X \beta + e},

2) fixed; a fixed-effects model using populations structure as fixed covariate
\deqn{Y = X \beta + Q \nu + e},

3) kinship; a mixed model including the coancestry matrix among genotypes as
a random effect following Parisseaux and Bernardo 2004
\deqn{Y = X \beta + Zu + e}

4) eigenstrat; a mixed-effects model including population structure but as
a random effect following Price et al. 2006 and Malosetti et al. 2007
\deqn{Y = X \beta + Q \nu + e}

5) QK; a mixed-effects model including both population structure and coancestry
among genotypes following Yu et al. 2006.
\deqn{Y = X \beta + Q\nu + Zu + e}

Principal component analysis (PCA) is used as a random effect in the Price model
including all significant axes, following Patterson et al. (2006).
When used in the Fixed or QK model, PCA, or another population structure is
included as a fixed effect.}

\item{provide.K}{K is the kinship matrix. If pedigree kinship is available, or a
specific kinship matrix is desired, set provide.k=TRUE.
Otherwise, a realized kinship matrix is estimated if needed for the model.
Indicates whether a qqplot shouldo be performed.
TRUE/FALSE term. FALSE is set as default.}

\item{covariates}{A vector of structure covariates.
Can be pca$scores for eigenstrat or any group for the fixed model.
Indicates whether a scatterplot should be performed.}

\item{trait}{Indicates the trait to be analyzed.}

\item{threshold}{Thresholds options are: Li&Ji (Li and Ji, 2005),
FDR (Benjamini and Hochberg, 1995), and set alpha levels (p.values)}

\item{p}{Alpha level (numeric) for test of marker-trait hypothesis.}

\item{out.file}{Name of the file to be written.
Example: 'GWAS fixed Groups model'.}
}
\value{
The function return p.values tested on the GWAS
analyses saved to gwas_reports, and Manhattan plots.
}
\description{
GWAS analysis with models:
naive: y= x + e, fixed: y = x + q + e,
kinship: y=x+z+e (Pariseaux and Bernardo, 2004),
QK: y = x + q + z + e (Yu et al., 2006), and
eigenstrat: y = x + q + e (Price et al.,
2006; Malosetti et al., 2007).
}
\details{
This analysis is performed with adjusted means of the field.
}
\note{
For multi-trait or multi-environment see GWAS.MEMQ
}
\examples{
\dontrun{
data (QA_geno)
data (QA_map)
data (QA_pheno)

P.data <- QA_pheno
G.data <- QA_geno
map.data <- QA_map

cross.data <- gwas.cross (P.data, G.data, map.data,
cross='gwas', heterozygotes=FALSE)
summary (cross.data)


#PCA
pca <- pca.analysis (crossobj=cross.data, p.val=0.05)

#LD.plots
linkdis.plots(crossobj = cross.data, heterozygotes = FALSE, chr = c('1'))

#Mixed model: Q+K
(qk.GWAS <- gwas.analysis (crossobj=cross.data4, method="QK", provide.K=FALSE,
covariates=pca$scores, trait="yield", threshold="Li&Ji", p=0.05,
out.file="GWAS Q + K model"))$selected

#Mixed model: Eigenanalysis (PCA as random component)
(pcaR.GWAS <- gwas.analysis(crossobj=cross.data4, method="eigenstrat",
provide.K=FALSE, covariates=pca$scores, trait="yield", threshold="Li&Ji",
 p=0.05, out.file="GWAS PCA as Random model"))$selected

#Mixed model: Kinship model
 (k.GWAS <- gwas.analysis(crossobj=cross.data4, method="kinship",
 provide.K=FALSE, covariates=FALSE, trait="yield",
 threshold="Li&Ji", p=0.05, out.file =" GWAS K as Random model "))$selected

#Fixed effects: Groups
 data (QA_pheno2)
 P.data.1 <- QA_pheno2
 covariate <- P.data.1 [,2]

 (g.GWAS <- gwas.analysis (crossobj=cross.data4,
 method="fixed", provide.K=FALSE, covariates=covariate,
 trait="yield", threshold="Li&Ji", p=0.05,
 out.file="GWAS fixed Groups model"))$selected

# Naive
 (naive.GWAS <- gwas.analysis(crossobj=cross.data4, method="naive",
  provide.K=FALSE, covariates=FALSE, trait="yield", threshold="Li&Ji",
  p=0.05, out.file="GWAS naive model"))$selected
}
}
\author{
Lucia Gutierrez
}
\references{
Benjamini and Hochberg (1995) Controlling the false discovery rate: a
            b practical and powerful approach to multiple testing.
            Journal of the Royal Statistical Society Series B 57, 289-300.

            Comadran J, Thomas W, van Eeuwijk F, Ceccarelli S, Grando S, Stanca A,
            Pecchioni N, Akar T, Al-Yassin A, Benbelkacem A, Ouabbou H, Bort J,
            Romagosa I, Hackett C, Russell J (2009) Patterns of
            genetic diversity and linkage disequilibrium in a
            highly structured Hordeum vulgare associatio-mapping
            population for the Mediterranean basin.
            Theor Appl Genet 119:175-187

            Li  J, Ji L (2005) Adjusting multiple testing in
            multilocus analyses using the eigenvalues of a
            correlation matrix. Heredity:1-7.

            Yu et al. (2006) A unified mixed-model method for
            association mapping that accounts for
            multiple levels of relatedness. Genetics 38:203-208.

            Malosetti et al. (2007) A mixed-model approach to
            association mapping using pedigree information
            with an illustration of resistance to Phytophthora infestans
            in potato. Genetics 175:879-889.

            Parisseaux B, Bernardo R (2004) Insilico mapping of
            quantitative trait loci in maize. Theor. Appl. Genet. 109:08-514.

            Peterson RF, Campbell AB, Han_nah AE, 1948. A diagrammatic scale for
            estimating rust intensity on leaves and stems of cereals.
            Canadian Journal of Genetics and Cytology C. 26:496-500

            Price et al. (2006) Principal components analysis
            corrects for stratificat on in genome-wide association studies,
            Nat. Genet. 38:904-909

            Turner, S. (2014). qqman: Q-Q and manhattan plots for GWAS data
            R package 0.1.2 https://CRAN.R-project.org/package=qqman
}
\seealso{
gwas.cross mq.g.diagnostics
}

