% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_lme4.R, R/bootstrap_nlme.R,
%   R/generics.R
\name{wild_bootstrap.lmerMod}
\alias{wild_bootstrap.lmerMod}
\alias{wild_bootstrap.lme}
\alias{wild_bootstrap}
\title{Wild Bootstrap for LME models}
\usage{
\method{wild_bootstrap}{lmerMod}(model, .f, B, hccme = c("hc2", "hc3"), aux.dist = c("f1", "f2"))

\method{wild_bootstrap}{lme}(model, .f, B, hccme = c("hc2", "hc3"), aux.dist = c("f1", "f2"))

wild_bootstrap(model, .f, B, hccme, aux.dist)
}
\arguments{
\item{model}{The model object you wish to bootstrap.}

\item{.f}{A function returning the statistic(s) of interest.}

\item{B}{The number of bootstrap resamples.}

\item{hccme}{either \code{"hc2"} or \code{"hc3"}, indicating which 
heteroscedasticity consistent covariance matrix estimator to use.}

\item{aux.dist}{either \code{"f1"} or \code{"f2"} indicating which auxiliary 
distribution to draw the errors from}
}
\value{
The returned value is an object of class "lmeresamp".
}
\description{
Generate wild bootstrap replicates of a statistic for a 
linear mixed-effects model.
}
\details{
The wild bootstrap algorithm for LMEs implemented here was outlined by  
Modugno & Giannerini (2015). The algorithm is outlined below:
\enumerate{
  \item Draw a random sample equal to the number of groups (clusters) from
     an auxillary distribution with mean zero and unit variance. 
     Denote these as \eqn{w_1, \ldots, w_g}.
  \item Calculate the selected heteroscedasticity consistent matrix estimator for
     the marginal residuals, \eqn{\tilde{v}_i}
  \item Generate bootstrap responses using the fitted equation: 
     \eqn{y_i^* = X_i \beta + \tilde{v}_i w_j}
  \item Refit the model and extract the statistic(s) of interest.
  \item Repeat steps 2-4 B times.
}
}
\references{
Modugno, L., & Giannerini, S. (2015). The Wild Bootstrap for 
   Multilevel Models. \emph{Communications in Statistics -- Theory and Methods}, 
   \bold{44}(22), 4812--4825.
}
\seealso{
\itemize{
  \item Examples are given in \code{\link{bootstrap}}
  \item \code{\link{parametric_bootstrap}}, \code{\link{resid_bootstrap}},
     \code{\link{case_bootstrap}}, \code{\link{reb_bootstrap}}, 
     \code{\link{wild_bootstrap}} for more details on a specific bootstrap.
  \item \code{\link[lme4]{bootMer}} in the \pkg{lme4} package for an 
     implementation of (semi-)parametric bootstrap for mixed models.
}
}
