% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{boot}
\alias{boot}
\title{Parametric bootstrap for LMLS}
\usage{
boot(m, num_samples = 1000, seed = NULL)
}
\arguments{
\item{m}{A location-scale regression model from the \code{\link[=lmls]{lmls()}} function.}

\item{num_samples}{The number of bootstrap samples to draw.}

\item{seed}{Either \code{NULL} or an integer that will be used in a call to
\code{\link[=set.seed]{set.seed()}} before simulating the response vectors.}
}
\value{
An \code{lmls} S3 object, see \code{\link[=lmls]{lmls()}}. The entry \code{boot} with the matrices of
bootstrap samples is added to the object as a list with the names \code{location}
and \code{scale}.
}
\description{
A simple parametric bootstrap algorithm for location-scale regression models
from the \code{\link[=lmls]{lmls()}} function.
}
\examples{
library(lmls)
m <- lmls(y ~ poly(x, 2), ~ x, data = abdom, light = FALSE)
m <- boot(m)
summary(m, type = "boot")
hist(m$boot$scale[, 2])
}
