% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_example.R
\name{initialize_example}
\alias{initialize_example}
\title{Initialize Scenario}
\usage{
initialize_example(n.i = 5, n = 30, q = 4, total.beta = 9,
  true.beta = c(1, 1, 1), seed = NULL)
}
\arguments{
\item{n.i}{integer, Observations per subject, Default: 5}

\item{n}{integer, Number of subjects, Default: 30}

\item{q}{integer, Number of random effects, Default: 4}

\item{total.beta}{integer, Number of simulated fixed effects, Default: 9}

\item{true.beta}{numeric, True of fixed effects indicies, Default: c(1,1,1)}

\item{seed}{integer, set a seed for reproducibility, Default: NULL}
}
\value{
(n.i*n) x (1+total.beta+q) matrix containing where the subjects index are the matrix rownames
\tabular{lcc}{
\strong{Description} \tab \strong{Parameter} \tab \strong{Dimension}\cr
Response \tab y \tab (n.i*n) x 1 \cr
Fixed \tab X \tab (n.i*n) x total.beta\cr
Random \tab Z \tab (n.i*n) x q \cr
}
}
\description{
Create a scenario to run the evaluation functions.
}
\examples{
 initialize_example(n.i = 5,n = 30,q=4,seed=1)
 initialize_example(n.i = 10,n = 60,q=4,seed=1)
 initialize_example(n.i = 5,n = 60,q=10,seed=1)
}
\seealso{
\code{\link[mvtnorm]{rmvnorm}}
}
