\name{pargld}
\alias{pargld}
\title{Estimate the Parameters of the Generalized Lambda Distribution}
\description{
This function estimates the parameters of the Generalized Lambda distribution given
the L-moments of the data in an ordinary L-moment object (\code{\link{lmom.ub}} or a trimmed L-moment object (\code{\link{TLmoms}} for \code{t=1}. The relation between distribution parameters and L-moments
is seen under \code{lmomgld}. There are no simple expressions for the parameters in terms of the
L-moments. This function is considered HIGHLY EXPERIMENTAL and general details of the algorithm are provided below. Further, consider that multiple parameter solutions are possible with the Generalized Lambda so some expertise in the distribution and other aspects are needed.
}
\usage{
pargld(lmom,result='best',verbose=FALSE)
}
\arguments{
  \item{lmom}{A L-moment object created by \code{\link{lmom.ub}}, \code{\link{pwm2lmom}}, or \code{\link{TLmoms}} with \code{trim=0}.}
  \item{result}{If \code{best}, then the minimum error solution is returned. If \code{dataframe}, then \code{data.frame} is returned with sequence of valid solutions sorted in ascending error order.}
  \item{verbose}{A logical switch on the verbosity of output.  Default is \code{verbose=FALSE}.}
}
\details{
Karian and Dudewicz (2000) summarize six regions of the \eqn{\kappa} and \eqn{h} space in which the Generalized Lambda distribution is valid for suitably choosen \eqn{\alpha}. Numerical experimentation suggestions that the L-moments are not valid in Regions 1 and 2. However, initial guesses of the parameters within each region are used for numerous separate \code{optim} (the R function) efforts to perform a least sum-of-square errors on the following objective function.

 \deqn{(\hat{\tau}_3 - \tilde{\tau}_3)^2 + (\hat{\tau}_4 - \tilde{\tau}_4)^2 \mbox{, }}

where \eqn{\hat{\tau}_r} is the L-moment ratio of the data, \eqn{\tilde{\tau}_r} is the estimated value of the L-moment ratio for the fitted distribution \eqn{\kappa} and \eqn{h} and \eqn{\tau_r} is the actual value of the L-moment ratio.

For each optimization a check on the validity of the parameters so produced is made--are the parameters consistent with the Generalized Lambda distribution and a second check is made on the validity of \eqn{\tau_3} and \eqn{\tau_4}. If both validity checks return \code{TRUE} then the optimization is retained if its sum-of-square error is less than the previous optimum value. It is possible for a given solution to be found outside the starting region of the initial guesses. The surface generated by the \eqn{\tau_3} and \eqn{\tau_4} equations seen in \code{\link{lmomgld}} is complex--different initial guesses within a given region can yield what appear to be radically different \eqn{\kappa} and \eqn{h}. Users are encouraged to \dQuote{play} with alternative solutions (see the \code{verbose} argument). A quick double check on the L-moments from the solved parameters using \code{\link{lmomgld}} is encouraged as well. Karvanen and others (2002, eq. 25) provide an equation expressing \eqn{\kappa} and \eqn{h} as equal (a symmetrical Generalized Lambda distribution) in terms of \eqn{\tau_4} and suggest that the equation be used to determine initial values for the parameters. This equation is used on an experimental basis for the final optimization attempt by this function.
}
\value{
  An R \code{list} is returned if \code{result='best'}.

  \item{type}{The type of distribution: \code{gld}.}
  \item{para}{The parameters of the distribution.}
  \item{error}{Smallest sum of square error found.}
  \item{tau5diff}{Difference between \eqn{\hat{\tau}_5} and the \eqn{\tilde{\tau}_5} of the fitted distribution.}
  \item{source}{The source of the parameters--\dQuote{pargld}.}

  An R \code{data.frame} is returned if \code{result='dataframe'}, which is sorted by ascending error.
  
  \item{attempt}{The attempt number that found valid L-moments and parameters of GLD.}
  \item{x}{The location parameter of the distribution.}
  \item{a}{The scale parameter of the distribution.}
  \item{k}{The 1st shape parameter of the distribution.}
  \item{h}{The 2nd shape parameter of the distribution.}
  \item{tau5_diff}{The absolute difference between \eqn{\hat{\tau}_5} of data to \eqn{\tilde{\tau}_5} of the fitted distribution.}  
  \item{error}{The sum of square error found.}
  \item{initial_k}{The starting point of the \eqn{\kappa} parameter.}
  \item{initial_h}{The starting point of the \eqn{h} parameter.}
}
\note{
Although the underlying derivations of the L-moments in terms of the parameters are sound and this function uses built-in functions of R for the optimization, this function should be considered experimental until further notice. The \dQuote{preferred} solution might not be appropriate. This function is not for production code. This is a cumbersome method of parameter solution and enhancements or total redesign of the algorithm is expected.
}
\source{
R hacking by W.H. Asquith in February 2006 with copy of Karian and Dudewicz (2000).
}
\references{
Karvanen, J., Eriksson, J., and Koivunen, V., 2002, Adaptive score functions for maximum likelihood ICA: Journal of VLSI Signal Processing, vol. 32, p. 82-92.

Karian, Z.A., and Dudewicz, E.J., 2000, Fitting statistical distributions--The generalized lambda distribution and generalized bootstrap methods: 
CRC Press, Boca Raton, FL, 438 p.
}
\author{ W.H. Asquith}
\seealso{\code{\link{lmom.ub}}, \code{\link{lmomgld}}, \code{\link{cdfgld}}, \code{\link{quagld}}, \code{\link{parTLgld}}
}
\examples{
lmr1 <- lmom.ub(rnorm(200))
P <- pargld(lmr1)
lmr2 <- lmomgld(P)
}
\keyword{distribution}
