% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localStrat.r
\name{covMatrix}
\alias{covMatrix}
\title{Cpp implementation of a function to compute the covariance matrix for a (sparse) matrix. The function is equivalent to the R command 'cov' applied to matrices.}
\usage{
covMatrix(m, dense = FALSE)
}
\arguments{
\item{m}{A (sparse) matrix for which the covariance matrix is sought. The input matrix is assumed to be oriented to contain the data for one individual per column.}

\item{dense}{Flag to switch between purpose-built dense or sparse implementations. Default is \code{dense=FALSE}.}
}
\value{
The covariance matrix of \code{m}.
}
\description{
Cpp implementation of a function to compute the covariance matrix for a (sparse) matrix. The function is equivalent to the R command 'cov' applied to matrices.
}
\examples{
library(locStra)
library(Matrix)
m <- matrix(sample(0:1,15,replace=TRUE),ncol=3)
sparseM <- Matrix(m,sparse=TRUE)
print(covMatrix(sparseM))

}
\references{
R Core Team (2014). R: A Language and Environment for Statistical Computing. R Foundation for Stat Comp, Vienna, Austria.
}
