% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locStra.r
\name{selectVariants}
\alias{selectVariants}
\title{Auxiliary function to invert minor alleles and to select those variants/loci exceeding a minimal cutoff value.}
\usage{
selectVariants(m, phased = FALSE, invertMinorAllele = TRUE, minVariants = 0)
}
\arguments{
\item{m}{A (sparse) input matrix. The input matrix is assumed to be oriented to contain the data for one individual per column.}

\item{phased}{Boolean flag to indicate if the input matrix is phased. Default is \code{phased=FALSE}.}

\item{invertMinorAllele}{Boolean flag to indicate if the minor allele should be inverted. Default is \code{invertMinorAllele=TRUE}.}

\item{minVariants}{Cutoff value for minimal number of variants for keeping a locus. Default is \code{minVariants=0}.}
}
\value{
The processed matrix with pruned variants/loci.
}
\description{
Auxiliary function to invert minor alleles and to select those variants/loci exceeding a minimal cutoff value.
}
\examples{
require(locStra)
m <- matrix(sample(0:1,100,replace=TRUE),ncol=10)
print(selectVariants(m))

}
