% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/logisticSVD.R
\name{plot.lsvd}
\alias{plot.lsvd}
\title{Plot logistic SVD}
\usage{
\method{plot}{lsvd}(x, type = c("trace", "loadings", "scores"), ...)
}
\arguments{
\item{x}{logistic SVD object}

\item{type}{the type of plot \code{type = "trace"} plots the algorithms progress by
iteration, \code{type = "loadings"} plots the first 2 principal component
loadings, \code{type = "scores"} plots the loadings first 2 principal component scores}

\item{...}{Additional arguments}
}
\description{
Plots the results of a logistic SVD
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

# run logistic SVD on it
lsvd = logisticSVD(mat, k = 2, main_effects = FALSE, use_irlba = FALSE)

\dontrun{
plot(lsvd)
}
}

