% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{electricity}
\alias{electricity}
\title{Stated preference data for the choice of electricity suppliers (from {mlogit} package)}
\format{
\tabular{ll}{
   Variable \tab Description \cr
   \code{id} \tab individual identifiers \cr
   \code{obsID} \tab identifier for unique choice observation \cr
   \code{choice} \tab dummy code for choice (1 or 0) \cr
   \code{alt} \tab alternative in each choice observation \cr
   \code{pf} \tab fixed price at a stated cents per kWh, with the price varying over suppliers and experiments, for scenario i=(1, 2, 3, 4), \cr
   \code{cl} \tab the length of contract that the supplier offered, in years (such as 1 year or 5 years.) During this contract period, the supplier guaranteed the prices and the buyer would have to pay a penalty if he/she switched to another supplier. The supplier could offer no contract in which case either side could stop the agreement at any time. This is recorded as a contract length of 0. \cr
   \code{loc} \tab is the supplier a local company. \cr
   \code{wk} \tab is the supplier a well-known company. \cr
   \code{tod} \tab a time-of-day rate under which the price is 11 cents per kWh from 8am to 8pm and 5 cents per kWh from 8pm to 8am. These TOD prices did not vary over suppliers or experiments: whenever the supplier was said to offer TOD, the prices were stated as above. \cr
   \code{seas} \tab a seasonal rate under which the price is 10 cents per kWh in the summer, 8 cents per kWh in the winter, and 6 cents per kWh in the spring and fall. Like TOD rates, these prices did not vary. Note that the price is for the electricity only, not transmission and distribution, which is supplied by the local regulated utility. \cr
}
}
\source{
\href{https://eml.berkeley.edu/~train/}{Kenneth Train's home page}
}
\usage{
data(electricity)
}
\description{
A sample of 2308 households in the United States.
}
\examples{
data(electricity)

head(electricity)
}
\references{
Croissant, Y. (2020). Estimation of Random Utility Models in R: The mlogit Package. Journal of Statistical Software, 95(11), 1–41.
\doi{10.18637/jss.v095.i11}
}
\keyword{datasets}
