% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ci}
\alias{ci}
\title{Obtain a confidence interval from coefficient draws}
\usage{
ci(df, level = 0.95)
}
\arguments{
\item{df}{A data frame of draws with all numeric columns.}

\item{level}{The sensitivity of the computed confidence interval (CI).
Defaults to \code{level = 0.95}, reflecting a 95\% CI.}
}
\description{
Returns a data frame with the columns 'mean', 'lower', and 'upper'
reflecting the mean and lower and upper bounds of a confidence
interval (quantiles) for every column in a data frame of draws
}
\examples{
library(logitr)

# Estimate a preference space model
mnl_pref <- logitr(
  data    = yogurt,
  outcome = "choice",
  obsID   = "obsID",
  pars    = c("price", "feat", "brand")
)

# Obtain 10,000 draws of parameters from model
coefs <- coef(mnl_pref)
covariance <- vcov(mnl_pref)
coef_draws <- as.data.frame(MASS::mvrnorm(10^4, coefs, covariance))

# Compute a confidence interval
ci(coef_draws, level = 0.95)

}
