% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp.R
\name{lol.project.dp}
\alias{lol.project.dp}
\title{Data  Piling}
\usage{
lol.project.dp(X, Y, ...)
}
\arguments{
\item{X}{\code{[n, d]} the data with \code{n} samples in \code{d} dimensions.}

\item{Y}{\code{[n]} the labels of the samples with \code{K} unique labels.}

\item{...}{optional args.}
}
\value{
A list containing the following:
\item{\code{A}}{\code{[d, r]} the projection matrix from \code{d} to \code{r} dimensions.}
\item{\code{ylabs}}{\code{[K]} vector containing the \code{K} unique, ordered class labels.}
\item{\code{centroids}}{\code{[K, d]} centroid matrix of the \code{K} unique, ordered classes in native \code{d} dimensions.}
\item{\code{priors}}{\code{[K]} vector containing the \code{K} prior probabilities for the unique, ordered classes.}
\item{\code{Xr}}{\code{[n, r]} the \code{n} data points in reduced dimensionality \code{r}.}
\item{\code{cr}}{\code{[K, r]} the \code{K} centroids in reduced dimensionality \code{r}.}
}
\description{
A function for implementing the Maximal Data Piling (MDP) Algorithm.
}
\section{Details}{

For more details see the help vignette:
\code{vignette("dp", package = "lolR")}
}

\examples{
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
model <- lol.project.dp(X=X, Y=Y)  # use mdp to project into maximal data piling
}
\author{
Minh Tang and Eric Bridgeford
}
