% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{nlist}
\alias{nlist}
\title{Named lists}
\usage{
nlist(...)
}
\arguments{
\item{...}{Objects to include in the list.}
}
\value{
A named list.
}
\description{
Create a named list using specified names or, if names are omitted, using the
names of the objects in the list. The code \code{list(a = a, b = b)} becomes
\code{nlist(a,b)} and \code{list(a = a, b = 2)} becomes \code{nlist(a, b =
2)}, etc.
}
\examples{

# All variables already defined
a <- rnorm(100)
b <- mat.or.vec(10, 3)
nlist(a,b)

# Define some variables in the call and take the rest from the environment
nlist(a, b, veggies = c("lettuce", "spinach"), fruits = c("banana", "papaya"))

}
\author{
Jonah Gabry
}
\seealso{
\code{\link[base]{list}}
}
\keyword{internal}

