% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cartesianxy2Polarxy.R
\name{Cartesianxy2Polarxy}
\alias{Cartesianxy2Polarxy}
\title{Transform the x, y positions from a Cartesian coordinate to a polar coordinate}
\usage{
Cartesianxy2Polarxy(layerGeom, coordinates, data, ggplotPanelParams, ...)
}
\arguments{
\item{layerGeom}{A \code{ggplot} layer object}

\item{coordinates}{A \code{ggplot} object coordinate system}

\item{data}{the data used for the transformation}

\item{ggplotPanelParams}{some non-data panel parameters,
i.e. the range of theta, the range of radius, theta major, theta minor, etc. It is obtained from the
\code{ggplot_build(p)$layout$panel_params} where "p" is a \code{ggplot} object}

\item{...}{for further use}
}
\description{
Used in the `loonLayer` construction to access the x, y positions embedded in the
polar coordinate system.
}
\examples{
p <- ggplot(mtcars, aes(wt, mpg)) +
       geom_point() +
       coord_polar()

layerGeom <- p$layers[[1L]]$geom
coordinates <- p$coordinates
build <- ggplot_build(p)
data <- build$data[[1L]]
ggplotPanelParams <- build$layout$panel_params[[1L]]

polarXY <- Cartesianxy2Polarxy(layerGeom, coordinates, data, ggplotPanelParams)
plot(polarXY$x, polarXY$y)
}
