% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive-ggproto.R
\name{active}
\alias{active}
\title{Modify the \code{active} component}
\usage{
active(active = NULL, activeGeomLayers = NULL)
}
\arguments{
\item{active}{a logical determining whether points appear or
not (default is \code{TRUE} for all points). If a logical vector is
given of length equal to the number of points,
then it identifies which points appear (\code{TRUE}) and
which do not (\code{FALSE}).}

\item{activeGeomLayers}{determine which geom layer is interactive. Only \code{geom_point()}
and \code{geom_histogram()} can be set as active geom layer(s) so far.
(Notice, more than one \code{geom_point()} layers can be set as active layers,
but only one \code{geom_histogram()} can be set as an active geom layer)}
}
\value{
a \code{ggproto} object
}
\description{
Set \code{active} or \code{activeGeomLayers}
}
\examples{
if(interactive()) {

  # set active layer
  l_ggplot(mtcars, aes(mpg, wt, shape = factor(cyl))) +
    geom_point(colour = "black", size = 4.5) +
    geom_point(colour = "pink", size = 4) +
    geom_point(aes(shape = factor(cyl))) +
    # only show manual transmission cars
    # in the second interactive layer
    active(active = mtcars$am == 1,
           activeGeomLayers = 2)

  # Then, click the `reactivate` button on loon inspector
  # to display all interactive points
}
}
\seealso{
\code{\link{linking}}, \code{\link{selection}}, \code{\link{zoom}},
\code{\link{hover}}, \code{\link{interactivity}}
}
