% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_plot3D.R
\name{l_plot3D.default}
\alias{l_plot3D.default}
\title{Create an interactive 3d scatterplot display}
\usage{
\method{l_plot3D}{default}(x, y = NULL, z = NULL, parent = NULL, ...)
}
\arguments{
\item{x}{the x, y and z arguments provide the x, y and z coordinates for the plot. Any reasonable way of defining the coordinates is acceptable. See the function xyz.coords for details. If supplied separately, they must be of the same length.}

\item{y}{please read in the argument description for the \code{x} argument above.}

\item{z}{please read in the argument description for the \code{x} argument above.}

\item{parent}{a valid Tk parent widget path. When the parent widget is
specified (i.e. not \code{NULL}) then the plot widget needs to be placed using
some geometry manager like \code{\link{tkpack}} or \code{\link{tkplace}} in
order to be displayed. See the examples below.}

\item{...}{named arguments to modify plot states.}
}
\description{
Creates an interactive 3d scatterplot. Also, if no loon
  inspector is open then the \code{l_plot3D} call will also open a loon
  inspector.
}
\details{
The scatterplot displays a number of direct interactions with the
  mouse and keyboard, these include: rotating, zooming towards the mouse cursor using
  the mouse wheel, panning by right-click dragging and various selection
  methods using the left mouse button such as sweeping, brushing and
  individual point selection. See the documentation for \code{\link{l_plot3D}}
  for more details about the interaction gestures.
}
\examples{

# default use as scatterplot

p1 <- with(quakes,
           l_plot3D(long, lat, depth)
           )

p2 <- with(quakes,
           l_plot3D(mag, stations, depth)
           )

# link the two plots p1 and p2
l_configure(p1, linkingGroup = "quakes", sync = "push")
l_configure(p2, linkingGroup = "quakes", sync = "push")

}
