% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_groupVisibility}
\alias{l_layer_groupVisibility}
\title{Queries visibility status of decendants}
\usage{
l_layer_groupVisibility(widget, layer)
}
\arguments{
\item{widget}{widget path or layer object of class \code{'l_layer'}}

\item{layer}{layer id. If the widget argument is of class \code{'l_layer'}
then the layer argument is not used}
}
\value{
\code{'all'}, \code{'part'} or \code{'none'} depending on the
  visibility status of the descendants.
}
\description{
Query whether all, part or none of the group layers descendants
  are visible.
}
\details{
Visibile layers are rendered, invisible ones are not. If any
  ancestor of a layer is set to be invisible then the layer is not rendered
  either. The layer visibility flag can be checked with
  \code{\link{l_layer_isVisible}} and the actual visibility (i.e. are all the
  ancesters visibile too) can be checked with
  \code{\link{l_layer_layerVisibility}}.

  Note that layer visibility is not a state of the layer itself,
  instead is information that is part of the layer collection (i.e. its
  parent widget).
}
\examples{

if(interactive()){

p <- l_plot()

g <- l_layer_group(p)
l1 <- l_layer_rectangle(p, x=0:1, y=0:1, parent=g)
l2 <- l_layer_oval(p, x=0:1, y=0:1, parent=g)

l_layer_groupVisibility(p, g)
l_layer_hide(p, l2)
l_layer_groupVisibility(p, g)
l_layer_hide(p, l1)
l_layer_groupVisibility(p, g)
l_layer_hide(p, g)
l_layer_groupVisibility(p, g)

}
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_layer_show}},
  \code{\link{l_layer_hide}}, \code{\link{l_layer_isVisible}},
  \code{\link{l_layer_layerVisibility}}
}
