% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_glyph_image.R
\name{l_glyph_add_image}
\alias{l_glyph_add_image}
\title{Add an image glyphs}
\usage{
l_glyph_add_image(widget, images, label = "", ...)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{images}{Tk image references, see the \code{\link{l_image_import_array}}
and \code{\link{l_image_import_files}} helper functions.}

\item{label}{label of a glyph (currently shown only in the glyph inspector)}

\item{...}{state arguments}
}
\description{
Image glyphs are useful to show pictures or other sophisticated
  compound glyphs. Note that images in the Tk canvas support transparancy.
}
\details{
For more information run: \code{l_help("learn_R_display_plot.html#images")}
}
\examples{
if(interactive()){

p <- with(olive, l_plot(palmitic ~ stearic, color = Region))
img_paths <- list.files(file.path(find.package(package = 'loon'), "images"), full.names = TRUE)
imgs <- setNames(l_image_import_files(img_paths),
                 tools::file_path_sans_ext(basename(img_paths)))
i <- pmatch(gsub("^[[:alpha:]]+-","", olive$Area), names(imgs), duplicates.ok = TRUE)

g <- l_glyph_add_image(p, imgs[i], label="Flags")
p['glyph'] <- g
}

}
\seealso{
\code{\link{l_glyph_add}}, \code{\link{l_image_import_array}},
  \code{\link{l_image_import_files}}, \code{\link{l_make_glyphs}}

Other glyph functions: 
\code{\link{l_glyph_add.default}()},
\code{\link{l_glyph_add_pointrange}()},
\code{\link{l_glyph_add_polygon}()},
\code{\link{l_glyph_add_serialaxes}()},
\code{\link{l_glyph_add_text}()},
\code{\link{l_glyph_add}()},
\code{\link{l_glyph_delete}()},
\code{\link{l_glyph_getLabel}()},
\code{\link{l_glyph_getType}()},
\code{\link{l_glyph_ids}()},
\code{\link{l_glyph_relabel}()},
\code{\link{l_primitiveGlyphs}()}
}
\concept{glyph functions}
