#' Constants for 'loose.rock' package
#'
#' Log level constants and the logger options.
#'
#' The logging configuration is managed by 'loose.rock.options', a function
#' generated by OptionsManager within 'futile.options'.
#'
#' @name loose.rock.options
#' @usage loose.rock.options(..., simplify = FALSE, update = list())
#'
#' @param update pair list of update to options
#' @param ... TODO
#' @param simplify TODO
#'
#' @return futile.options::OptionsManager object
#'
#' @seealso \code{futile.options}
loose.rock.options <- futile.options::OptionsManager(
  'loose.rock',
  default = list(
    compression = 'gzip',
    base.dir = tempdir.cache(),
    show.message = TRUE
  )
)

#' change cache.compression for run.cache
#'
#' @param compression see compression parameter in save function
#'
#' @return the new compression
#' @export
#'
#' @examples
#' cache.compression('bzip2')
cache.compression <- function(compression = NULL) {
  if (!is.null(compression))
    loose.rock.options(update = list('compression', compression))
  return(loose.rock.options('compression'))
}

#' change base.dir for run.cache
#'
#' @param path to base directory where cache is saved
#'
#' @return the new path
#' @export
#'
#' @examples
#' base.dir('/tmp/cache')
base.dir <- function(path = NULL) {
  if (!is.null(path))
    loose.rock.options(update = list('base.dir', path))
  return(loose.rock.options('base.dir'))
}

#' Show messages option in run.cache
#'
#' @param show.message boolean indicating to show messages or not
#'
#' @return the show.message option
#' @export
#'
#' @examples
#' show.message(FALSE)
show.message <- function(show.message = NULL) {
  if (!is.null(show.message))
    loose.rock.options(update = list('show.message', show.message))
  return(loose.rock.options('show.message'))
}
