% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.lori.R
\name{pool.lori}
\alias{pool.lori}
\title{The pool.lori method aggregates lori multiple imputation results.
Multiple imputation allows to produce estimates of missing
values, as well as intervals of variability. The classical
procedure is to perform multiple imputation using the mi.lori
method, and to aggregate them using the pool.lori method.}
\usage{
pool.lori(res.mi)
}
\arguments{
\item{res.mi}{a multiple imputation result from the function mi.lori}
}
\value{
\item{pool.impute}{a list containing the pooled means (mean) and variance (var) of the imputed values}
\item{pool.alpha}{a list containing the pooled means (mean) and variance (var) of the row effects}
\item{pool.beta}{a list containing the pooled means (mean) and variance (var) of the column effects}
\item{pool.epsilon}{a list containing the pooled means (mean) and variance (var) of the covariate effects}
\item{pool.theta}{a list containing the pooled means (mean) and variance (var) of the interactions}
}
\description{
The pool.lori method aggregates lori multiple imputation results.
Multiple imputation allows to produce estimates of missing
values, as well as intervals of variability. The classical
procedure is to perform multiple imputation using the mi.lori
method, and to aggregate them using the pool.lori method.
}
\examples{
X <- matrix(rnorm(50), 25)
Y <- matrix(rpois(25, 1:25), 5)
res <- mi.lori(Y, X, 10, 10, 2)
poolres <- pool.lori(res)
}
