% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lotri.R
\name{lotriSep}
\alias{lotriSep}
\title{Separate a lotri matrix into above and below lotri matrices}
\usage{
lotriSep(x, above, below, aboveStart = 1L, belowStart = 1L)
}
\arguments{
\item{x}{lotri matrix}

\item{above}{Named integer vector listing variability above the id
level.  Each element lists the number of population differences
in the whole data-set (as integer)}

\item{below}{Named integer vector listing variability below the id
level.  Each element lists the number of items below the
individual level.  For example with 3 occasions per indivdiual
you could use 'c(occ=3L)'}

\item{aboveStart}{Add the attribute of where THETA[#] will be added}

\item{belowStart}{Add the attribute of where ETA[#] will be added}
}
\value{
List of two lotri matrices
}
\description{
This is used for creating nesting simulations in `RxODE` and may
not be useful for external function calls.
}
\examples{
omega <- lotri(lotri(eta.Cl ~ 0.1,
                        eta.Ka ~ 0.1) | id(nu=100),
                  lotri(eye.Cl ~ 0.05,
                        eye.Ka ~ 0.05) | eye(nu=50),
                  lotri(iov.Cl ~ 0.01,
                        iov.Ka ~ 0.01) | occ(nu=200),
                  lotri(inv.Cl ~ 0.02,
                        inv.Ka ~ 0.02) | inv(nu=10))

lotriSep(omega, above=c(inv=10L), below=c(eye=2L, occ=4L))
}
\author{
Matthew Fidler
}
